<?php
class Registration
{
  private $dbo = null;
  
  private $fields = array();
  
  function __construct($dbo)
  {
    $this->dbo = $dbo;
    $this->initFields();
  }
  
  function initFields()
  {
    $this->fields['email'] = new FormInput('email', 'Adres e-mail');
    $this->fields['hasło'] = new FormInput('hasło', 'Hasło', '', 'password');
    $this->fields['hasło2'] = new FormInput('hasło2', 'Powtórz hasło', '', 'password');
    $this->fields['imię'] = new FormInput('imię', 'Imię');
    $this->fields['nazwisko'] = new FormInput('nazwisko', 'Nazwisko');
    $this->fields['ulica'] = new FormInput('ulica', 'Ulica');
    $this->fields['nr_domu'] = new FormInput('nr_domu', 'Numer domu');
    $this->fields['nr_mieszkania'] =  
      new FormInput('nr_mieszkania', 'Numer mieszkania', '', 'text', false);
    $this->fields['miejscowość'] = new FormInput('miejscowość', 'Miejscowość');
    $this->fields['kod'] = new FormInput('kod', 'Kod pocztowy');
    $this->fields['kraj'] = new FormInput('kraj', 'Kraj');
  }
  
  function showRegistrationForm()
  {
    $formData = $this->fields;
    include 'templates/registrationForm.php'; 
  }
  
  function registerUser()
  {
    foreach($this->fields as $name => $val){
      if(!isset($_POST[$name])){
        return FORM_DATA_MISSING;
      }
    }
    
    //Tutaj lub po przefiltrowaniu dodatkowa weryfikacja danych,
    //w tym sprawdzenie długości ciągów, znaków niedozwolonych itp
    
    //Odczyt i przefiltrowanie danych z formularza
    $fieldsFromForm = array();
    $emptyFieldDetected = false;
    foreach($this->fields as $name => $val){
      if($val->type != 'password'){
        $fieldsFromForm[$name] = filter_input(INPUT_POST, $name, 
                                 FILTER_SANITIZE_SPECIAL_CHARS);
      } else {
        $fieldsFromForm[$name] = $_POST[$name];
      }
      
      $fieldsFromForm[$name] = 
        $this->dbo->real_escape_string($fieldsFromForm[$name]);
        
      if($fieldsFromForm[$name] == '' && $val->required){
        $emptyFieldDetected = true;
      }
    }
    
    //Sprawdzenie czy wykryto puste pola
    if($emptyFieldDetected){
      return FORM_DATA_MISSING;
    }
    
    //Sprawdzenie czy podany e-mail jest już w bazie
    $query = "SELECT COUNT(*) FROM Klienci WHERE Email='"
           . $fieldsFromForm['email'] . "'";
    if($this->dbo->getQuerySingleResult($query) > 0){
      return USER_NAME_ALREADY_EXISTS;
    }
    
    //Sprawdzenie zgodności hasła z obu pól
    if($fieldsFromForm['hasło'] != $fieldsFromForm['hasło2']){
      return PASSWORDS_DO_NOT_MATCH;
    }
    unset($fieldsFromForm['hasło2']);
    unset($this->fields['hasło2']);
    
    //Zakodowanie hasła
    $fieldsFromForm['hasło'] = crypt($fieldsFromForm['hasło']);
    
    //Przygotowanie ciągów nazw pól i wartości pól dla zapytania SQL
    $fieldsNames = '`'.implode('`,`', array_keys($this->fields)).'`';
    $fieldsVals = '\''.implode('\',\'', $fieldsFromForm).'\'';
    
    //Formowanie i wykonanie zapytania
    $query = "INSERT INTO Klienci ($fieldsNames) VALUES ($fieldsVals)";

    if($this->dbo->query($query)){
      return ACTION_OK;
    }
    else{
      return ACTION_FAILED;
    }
  }
}
